/*
 * Decompiled with CFR 0.152.
 */
package catserver.server.launch;

import catserver.server.launch.Java11Support;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.launchwrapper.LogWrapper;
import org.apache.logging.log4j.Level;

public class Java11Launch {
    public static void main(String[] args) {
        new Java11Launch().launch(args);
    }

    private Java11Launch() {
        try {
            AccessController.doPrivileged(() -> {
                Field ucpField = null;
                try {
                    ucpField = Java11Launch.class.getClassLoader().getClass().getDeclaredField("ucp");
                }
                catch (NoSuchFieldException e) {
                    ucpField = Java11Launch.class.getClassLoader().getClass().getSuperclass().getDeclaredField("ucp");
                }
                Object ucp = Java11Support.FieldHelper.get(Java11Launch.class.getClassLoader(), ucpField);
                Field pathField = ucp.getClass().getDeclaredField("path");
                URL[] sources = ((List)Java11Support.FieldHelper.get(ucp, pathField)).toArray(new URL[0]);
                Launch.classLoader = new LaunchClassLoader(sources);
                Launch.blackboard = new HashMap();
                Thread.currentThread().setContextClassLoader((ClassLoader)Launch.classLoader);
                Launch.classLoader.addClassLoaderExclusion("javax.");
                return null;
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void launch(String[] args) {
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        ArgumentAcceptingOptionSpec profileOption = parser.accepts("version", "The version we launched with").withRequiredArg();
        ArgumentAcceptingOptionSpec gameDirOption = parser.accepts("gameDir", "Alternative game directory").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec assetsDirOption = parser.accepts("assetsDir", "Assets directory").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec tweakClassOption = parser.accepts("tweakClass", "Tweak class(es) to load").withRequiredArg().defaultsTo((Object)"net.minecraft.launchwrapper.VanillaTweaker", (Object[])new String[0]);
        NonOptionArgumentSpec nonOption = parser.nonOptions();
        OptionSet options = parser.parse(args);
        Launch.minecraftHome = (File)options.valueOf((OptionSpec)gameDirOption);
        Launch.assetsDir = (File)options.valueOf((OptionSpec)assetsDirOption);
        String profileName = (String)options.valueOf((OptionSpec)profileOption);
        ArrayList tweakClassNames = new ArrayList(options.valuesOf((OptionSpec)tweakClassOption));
        ArrayList<String> argumentList = new ArrayList<String>();
        Launch.blackboard.put("TweakClasses", tweakClassNames);
        Launch.blackboard.put("ArgumentList", argumentList);
        HashSet<String> allTweakerNames = new HashSet<String>();
        ArrayList<ITweaker> allTweakers = new ArrayList<ITweaker>();
        try {
            ArrayList<ITweaker> tweakers = new ArrayList<ITweaker>(tweakClassNames.size() + 1);
            Launch.blackboard.put("Tweaks", tweakers);
            ITweaker primaryTweaker = null;
            do {
                Iterator it = tweakClassNames.iterator();
                while (it.hasNext()) {
                    String tweakName = (String)it.next();
                    if (allTweakerNames.contains(tweakName)) {
                        LogWrapper.log((Level)Level.WARN, (String)"Tweak class name %s has already been visited -- skipping", (Object[])new Object[]{tweakName});
                        it.remove();
                        continue;
                    }
                    allTweakerNames.add(tweakName);
                    LogWrapper.log((Level)Level.INFO, (String)"Loading tweak class name %s", (Object[])new Object[]{tweakName});
                    Launch.classLoader.addClassLoaderExclusion(tweakName.substring(0, tweakName.lastIndexOf(46)));
                    ITweaker tweaker = (ITweaker)Class.forName(tweakName, true, (ClassLoader)Launch.classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
                    tweakers.add(tweaker);
                    it.remove();
                    if (primaryTweaker != null) continue;
                    LogWrapper.log((Level)Level.INFO, (String)"Using primary tweak class name %s", (Object[])new Object[]{tweakName});
                    primaryTweaker = tweaker;
                }
                Iterator it2 = tweakers.iterator();
                while (it2.hasNext()) {
                    ITweaker tweaker2 = (ITweaker)it2.next();
                    LogWrapper.log((Level)Level.INFO, (String)"Calling tweak class %s", (Object[])new Object[]{tweaker2.getClass().getName()});
                    tweaker2.acceptOptions(options.valuesOf((OptionSpec)nonOption), Launch.minecraftHome, Launch.assetsDir, profileName);
                    tweaker2.injectIntoClassLoader(Launch.classLoader);
                    allTweakers.add(tweaker2);
                    it2.remove();
                }
            } while (!tweakClassNames.isEmpty());
            for (ITweaker tweaker3 : allTweakers) {
                argumentList.addAll(Arrays.asList(tweaker3.getLaunchArguments()));
            }
            String launchTarget = primaryTweaker.getLaunchTarget();
            Class<?> clazz = Class.forName(launchTarget, false, (ClassLoader)Launch.classLoader);
            Method mainMethod = clazz.getMethod("main", String[].class);
            LogWrapper.info((String)"Launching wrapped minecraft {%s}", (Object[])new Object[]{launchTarget});
            mainMethod.invoke(null, new Object[]{argumentList.toArray(new String[0])});
        }
        catch (Exception e) {
            LogWrapper.log((Level)Level.ERROR, (Throwable)e, (String)"Unable to launch", (Object[])new Object[0]);
            System.exit(1);
        }
    }
}

